const sqlite3 = require('sqlite3').verbose();
const path = require('path');
const dbPath = path.resolve(__dirname, 'database.sqlite');
const db = new sqlite3.Database(dbPath);

db.serialize(() => {
    // Add sizes and colors columns
    db.run("ALTER TABLE products ADD COLUMN sizes TEXT", (err) => {
        if (err) console.log("sizes column might already exist or error: " + err.message);
        else console.log("Added sizes column");
    });
    db.run("ALTER TABLE products ADD COLUMN colors TEXT", (err) => {
        if (err) console.log("colors column might already exist or error: " + err.message);
        else console.log("Added colors column");
    });
});

db.close();
