const sqlite3 = require('sqlite3').verbose();
const path = require('path');
const dbPath = path.resolve(__dirname, 'database.sqlite');
const db = new sqlite3.Database(dbPath);

db.serialize(() => {
    // Add size and color columns to order_items
    db.run("ALTER TABLE order_items ADD COLUMN size TEXT", (err) => {
        if (err) console.log("size column might already exist in order_items or error: " + err.message);
        else console.log("Added size column to order_items");
    });
    db.run("ALTER TABLE order_items ADD COLUMN color TEXT", (err) => {
        if (err) console.log("color column might already exist in order_items or error: " + err.message);
        else console.log("Added color column to order_items");
    });
});

db.close();
