const sqlite3 = require('sqlite3').verbose();
const path = require('path');

const dbPath = path.resolve(__dirname, 'database.sqlite');
const db = new sqlite3.Database(dbPath);

db.serialize(() => {
    // Add sku without UNIQUE first
    db.run(`ALTER TABLE products ADD COLUMN sku TEXT`, (err) => {
        if (err && !err.message.includes("duplicate column")) {
            console.error(`Error adding column sku:`, err.message);
        } else {
            console.log(`Column sku added to products.`);
            // Create unique index for sku
            db.run(`CREATE UNIQUE INDEX IF NOT EXISTS idx_products_sku ON products(sku)`);
        }
    });
});

db.close();
